<?php
include "connection.php";

// -----------------------------
// GOOGLE SHEETS CONFIGURATION
// -----------------------------
$google_key_file = "/home/gwadarone/keys/google.json";
$sheet_id = "1cJ4gqcpFYvD_fzr3Zp29s0nairJSn7kETNPla48U7lY";
$sheet_name = "GENERAL TAB"; // plain name
$api_id_column = "K"; // Column to update with API ID

// Load service account
$service_account = json_decode(file_get_contents($google_key_file), true);

// Base64URL encode function
function base64url_encode($data) {
    return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');
}

// Get Google Access Token
$header = ["alg" => "RS256", "typ" => "JWT"];
$now = time();
$jwt_claim_set = [
    "iss" => $service_account["client_email"],
    "scope" => "https://www.googleapis.com/auth/spreadsheets",
    "aud" => "https://oauth2.googleapis.com/token",
    "exp" => $now + 3600,
    "iat" => $now
];
$header_encoded = base64url_encode(json_encode($header));
$claims_encoded = base64url_encode(json_encode($jwt_claim_set));
$signature_input = $header_encoded . "." . $claims_encoded;
openssl_sign($signature_input, $signature, $service_account["private_key"], "sha256WithRSAEncryption");
$signature_encoded = base64url_encode($signature);
$jwt = $header_encoded . "." . $claims_encoded . "." . $signature_encoded;

// Exchange JWT for access token
$token_request_data = http_build_query([
    "grant_type" => "urn:ietf:params:oauth:grant-type:jwt-bearer",
    "assertion" => $jwt
]);
$ch = curl_init("https://oauth2.googleapis.com/token");
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $token_request_data);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);
$token_response = json_decode($response, true);
if (!isset($token_response["access_token"])) {
    die("Failed to get access token: " . $response);
}
$access_token = $token_response["access_token"];

// -----------------------------
// PROCESS DATABASE RECORD
// -----------------------------
$updated_at = date('Y-m-d H:i:s');
$submitted_date = date('m/d/Y');

$sql = "SELECT * FROM chimney_services WHERE status = 0 LIMIT 1";
$result = mysqli_query($conn, $sql);

if(mysqli_num_rows($result) > 0) {
    while($data = mysqli_fetch_assoc($result)) {
        $name = $data['name'];
        $address = $data['address'];
        $phone = preg_replace('/[^0-9]/', '', $data['phone']);
        $hours = $data['hours'];
        $category = $data['category'];
        
        // If service is separate, format it too
        if (!empty($category)) {
            $categorySlug = strtolower(str_replace(" ", "_", $category));
        }

        $service = $data['service'];
        
        // If service is separate, format it too
        if (!empty($service)) {
            $serviceSlug = strtolower(str_replace(" ", "_", $service));
        }

        $db_id = $data['id'];
        $sheet_row = $data['sheet_row_index']; // Column in DB with sheet row

        $hoursRange = explode("-", $hours);
        $open = trim($hoursRange[0]);
        $close = trim($hoursRange[1]);

        $hoursJson = [
            "monday" => [["open" => $open, "close" => $close]],
            "tuesday" => [["open" => $open, "close" => $close]],
            "wednesday" => [["open" => $open, "close" => $close]],
            "thursday" => [["open" => $open, "close" => $close]],
            "friday" => [["open" => $open, "close" => $close]],
            "saturday" => [["open" => $open, "close" => $close]],
            "sunday" => [["open" => $open, "close" => $close]],
        ];

        $parts = explode(",", $address);
        $street = trim($parts[0]);
        $city = trim($parts[1]);
        $stateZip = explode(" ", trim($parts[2]));
        $state = $stateZip[0];
        $zip = $stateZip[1];

        $payload = [
            "packages" => [["package_name" => "core_search"]],
            "business" => [
                "name" => $name,
                "legal_name" => $name,
                "addresses" => [[
                    "street" => $street,
                    "city" => $city,
                    "state" => $state,
                    "zip" => $zip,
                    "country" => "US"
                ]],
                "phones" => [[
                    "phone_number" => $phone,
                    "type" => "landline"
                ]],
                "hours" => $hoursJson,
                "categories" => [
                    ["name" => $categorySlug],
                    ["name" => $serviceSlug]
                ]
            ]
        ];

        $jsonPayload = json_encode($payload, JSON_UNESCAPED_SLASHES);
        $url = "https://api.ldex.co/listings-management/api/v2/businesses?apikey=HVEwRb5qpLVfl8mmaprWuCjM9immjJRO";

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonPayload);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);

        $responseData = json_decode($response, true);
        $business_id = isset($responseData['business_id']) ? $responseData['business_id'] : '';
        $business_id = mysqli_real_escape_string($conn, $business_id);
        $api_response = mysqli_real_escape_string($conn, $response);

        // Update DB
        $update = "
            UPDATE chimney_services
            SET status = 1,
                api_returned_id = '$business_id',
                updated_at = '$updated_at',
                api_response = '$api_response',
                submitted = '$submitted_date'
            WHERE id = $db_id
        ";
        mysqli_query($conn, $update);

        echo "Updated record ID: $db_id<br>";

        // -----------------------------
        // UPDATE GOOGLE SHEET
        // -----------------------------
        $body_range = $sheet_name . "!$api_id_column$sheet_row";
        $url_range = str_replace(" ", "%20", $sheet_name) . "!$api_id_column$sheet_row";
        $update_url = "https://sheets.googleapis.com/v4/spreadsheets/$sheet_id/values/$url_range?valueInputOption=USER_ENTERED";

        $data = [
            "range" => $body_range,
            "majorDimension" => "ROWS",
            "values" => [ [$business_id] ]
        ];

        $ch = curl_init($update_url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Content-Type: application/json",
            "Authorization: Bearer $access_token"
        ]);
        $update_response = curl_exec($ch);
        curl_close($ch);

        echo "Google Sheet updated for row $sheet_row: $update_response<br>";
    }
} else {
    echo "No pending records to process.";
}
?>
