<?php
include "connection.php"; 

$created_at = date('Y-m-d H:i:s');

// GOOGLE SHEET CSV URL (after publishing)
// $csvUrl = "https://docs.google.com/spreadsheets/d/e/2PACX-1vSLvI6OppPELqSEYuVMKPcFQIU2_JThww19PKj9qNE2LLaIPgKcksi9caECYR8y--l6p_lIwp9QKCE7/pub?gid=1770304135&single=true&output=csv";
$csvUrl = "https://docs.google.com/spreadsheets/d/e/2PACX-1vSLvI6OppPELqSEYuVMKPcFQIU2_JThww19PKj9qNE2LLaIPgKcksi9caECYR8y--l6p_lIwp9QKCE7/pub?gid=1808653165&single=true&output=csv";

// Fetch CSV content
$csvData = file_get_contents($csvUrl);

if (!$csvData) {
    die("Failed to load CSV from Google Sheets.");
}

$rows = array_map("str_getcsv", explode("\n", $csvData));

// Remove header row
$header = array_shift($rows);

$rowIndex = 2; // Start from 2 because header is row 1

foreach ($rows as $row) {
    if (count($row) < 12) {
        $rowIndex++;
        continue; // skip empty or incomplete rows
    }

    list(
        $name,
        $address,
        $phone,
        $hours,
        $category,
        $service,
        $json_file,
        $phone_company,
        $submitted,
        $published,
        $api_returned_id,
        $sheet
    ) = $row;

    // Skip the row if name, address, or phone is empty
    if (empty($name) || empty($address)) {
        $rowIndex++;
        continue; // Skip to the next row
    }

    // Escape values
    $name          = mysqli_real_escape_string($conn, $name);
    $address       = mysqli_real_escape_string($conn, $address);
    $phone         = mysqli_real_escape_string($conn, $phone);
    $hours         = mysqli_real_escape_string($conn, $hours);
    $category      = mysqli_real_escape_string($conn, $category);
    $service       = mysqli_real_escape_string($conn, $service);
    $json_file     = mysqli_real_escape_string($conn, $json_file);
    $phone_company = mysqli_real_escape_string($conn, $phone_company);
    $submitted     = mysqli_real_escape_string($conn, $submitted);
    $published     = mysqli_real_escape_string($conn, $published);
    $api_returned_id = mysqli_real_escape_string($conn, $api_returned_id);
    $sheet         = mysqli_real_escape_string($conn, $sheet);
    
    // Determine status based on api_returned_id
    $status = empty($api_returned_id) ? 0 : 1;

    // Insert only if new
    $sql = "INSERT IGNORE INTO chimney_services 
        (name, address, phone, hours, category, service, json_file, phone_company, submitted, published, api_returned_id, sheet, sheet_row_index, created_at, status)
        VALUES 
        ('$name', '$address', '$phone', '$hours', '$category', '$service', '$json_file', '$phone_company', '$submitted', '$published', '$api_returned_id', '$sheet', '$rowIndex', '$created_at', '$status')";

    if (!mysqli_query($conn, $sql)) {
        echo "Insert error: " . mysqli_error($conn) . "<br>";
    }

    $rowIndex++;
}

echo "Data import completed.";
?>
